<?php
/**
 * Avalanche for Magento 1.8+
 * Designed by Fast Division (http://fastdivision.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://fastdivision.com/legal/license.txt
 *
 * @author     Fast Division
 * @version    1.5.0
 * @copyright  Copyright 2013 Fast Division
 * @license    http://fastdivision.com/legal/license.txt
 */

class FastDivision_Widgets_Model_Bestsellers extends Mage_Reports_Model_Resource_Product_Collection
{
    /**
     * Add ordered qty's
     *
     * @param string $from
     * @param string $to
     * @return Mage_Reports_Model_Resource_Product_Collection
     */
    public function addOrderedQty($from = '', $to = '')
    {
        $adapter              = $this->getConnection();
        $compositeTypeIds     = '';
        $orderTableAliasName  = $adapter->quoteIdentifier('order');

        $orderJoinCondition   = array(
            $orderTableAliasName . '.entity_id = order_items.order_id',
            $adapter->quoteInto("{$orderTableAliasName}.state <> ?", Mage_Sales_Model_Order::STATE_CANCELED),

        );

        if($this->isEnabledFlat()) {
            $productJoinCondition = array(
                $adapter->quoteInto('(e.type_id NOT IN (?))', $compositeTypeIds),
                'e.entity_id = order_items.product_id',
                // $adapter->quoteInto('e.entity_type_id = ?', $this->getProductEntityTypeId())
            );
        } else {
            $productJoinCondition = array(
                $adapter->quoteInto('(e.type_id NOT IN (?))', $compositeTypeIds),
                'e.entity_id = order_items.product_id',
                $adapter->quoteInto('e.entity_type_id = ?', $this->getProductEntityTypeId())
            );           
        }

        if ($from != '' && $to != '') {
            $fieldName            = $orderTableAliasName . '.created_at';
            $orderJoinCondition[] = $this->_prepareBetweenSql($fieldName, $from, $to);
        }

        if($this->isEnabledFlat()) {
            $this->getSelect()->reset()
                ->from(
                    array('order_items' => $this->getTable('sales/order_item')),
                    array(
                        'ordered_qty' => 'SUM(order_items.qty_ordered)',
                        'order_items_name' => 'order_items.name'
                    ))
                ->joinInner(
                    array('order' => $this->getTable('sales/order')),
                    implode(' AND ', $orderJoinCondition),
                    array())
                ->joinLeft(
                    array('e' => $this->getEntity()->getFlatTableName()),
                    implode(' AND ', $productJoinCondition),
                    array(
                        'entity_id' => 'order_items.product_id',
                        // 'entity_type_id' => 'e.entity_type_id',
                        'attribute_set_id' => 'e.attribute_set_id',
                        'type_id' => 'e.type_id',
                        'sku' => 'e.sku',
                        'has_options' => 'e.has_options',
                        'required_options' => 'e.required_options',
                        'created_at' => 'e.created_at',
                        'updated_at' => 'e.updated_at'
                    ))
                ->where('parent_item_id IS NULL')
                ->group('order_items.product_id')
                ->having('SUM(order_items.qty_ordered) > ?', 0);
        } else {
            $this->getSelect()->reset()
                ->from(
                    array('order_items' => $this->getTable('sales/order_item')),
                    array(
                        'ordered_qty' => 'SUM(order_items.qty_ordered)',
                        'order_items_name' => 'order_items.name'
                    ))
                ->joinInner(
                    array('order' => $this->getTable('sales/order')),
                    implode(' AND ', $orderJoinCondition),
                    array())
                ->joinLeft(
                    array('e' => $this->getProductEntityTableName()),
                    implode(' AND ', $productJoinCondition),
                    array(
                        'entity_id' => 'order_items.product_id',
                        'entity_type_id' => 'e.entity_type_id',
                        'attribute_set_id' => 'e.attribute_set_id',
                        'type_id' => 'e.type_id',
                        'sku' => 'e.sku',
                        'has_options' => 'e.has_options',
                        'required_options' => 'e.required_options',
                        'created_at' => 'e.created_at',
                        'updated_at' => 'e.updated_at'
                    ))
                ->where('parent_item_id IS NULL')
                ->group('order_items.product_id')
                ->having('SUM(order_items.qty_ordered) > ?', 0);
        }

        return $this;
    }
}